/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.contexts;

import com.mlib.Utility;
import com.mlib.contexts.base.Context;
import com.mlib.contexts.base.Contexts;
import com.mlib.contexts.data.ILevelData;
import com.mlib.contexts.data.IPositionData;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OnLootLevel {
    public static Context<Data> listen(Consumer<Data> consumer) {
        return Contexts.get(Data.class).add(consumer);
    }

    @SubscribeEvent
    public static void onLootLevel(LootingLevelEvent event) {
        Contexts.get(Data.class).dispatch(new Data(event));
    }

    public static class Data
    implements ILevelData,
    IPositionData {
        public final LootingLevelEvent event;
        @Nullable
        public final DamageSource source;
        @Nullable
        public final LivingEntity attacker;

        public Data(LootingLevelEvent event) {
            this.event = event;
            this.source = event.getDamageSource();
            this.attacker = this.source != null ? Utility.castIfPossible(LivingEntity.class, this.source.m_7639_()) : null;
        }

        @Override
        public Level getLevel() {
            return this.attacker != null ? this.attacker.m_9236_() : null;
        }

        @Override
        public Vec3 getPosition() {
            return this.attacker != null ? this.attacker.m_20182_() : new Vec3(0.0, 0.0, 0.0);
        }
    }
}

